/*
 * Decompiled with CFR 0.152.
 */
package acmx.classfile;

import acm.util.ErrorException;
import acmx.classfile.ClassEntry;
import acmx.classfile.DoubleEntry;
import acmx.classfile.FieldRefEntry;
import acmx.classfile.FloatEntry;
import acmx.classfile.IntegerEntry;
import acmx.classfile.InterfaceMethodRefEntry;
import acmx.classfile.JavaClass;
import acmx.classfile.LongEntry;
import acmx.classfile.MethodRefEntry;
import acmx.classfile.NameAndTypeEntry;
import acmx.classfile.StringEntry;
import acmx.classfile.UTF8Entry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ConstantPoolEntry {
    private JavaClass owner;
    private int entryType;

    protected ConstantPoolEntry(int type, JavaClass jc) {
        this.entryType = type;
        this.owner = jc;
    }

    public int getEntryType() {
        return this.entryType;
    }

    public boolean takesTwoSlots() {
        return false;
    }

    public JavaClass getOwner() {
        return this.owner;
    }

    public abstract void write(DataOutputStream var1) throws IOException;

    public static ConstantPoolEntry readNext(DataInputStream in, JavaClass jc) throws IOException {
        int type = in.read();
        switch (type) {
            case 1: {
                return new UTF8Entry(in, jc);
            }
            case 3: {
                return new IntegerEntry(in, jc);
            }
            case 4: {
                return new FloatEntry(in, jc);
            }
            case 5: {
                return new LongEntry(in, jc);
            }
            case 6: {
                return new DoubleEntry(in, jc);
            }
            case 7: {
                return new ClassEntry(in, jc);
            }
            case 8: {
                return new StringEntry(in, jc);
            }
            case 9: {
                return new FieldRefEntry(in, jc);
            }
            case 10: {
                return new MethodRefEntry(in, jc);
            }
            case 11: {
                return new InterfaceMethodRefEntry(in, jc);
            }
            case 12: {
                return new NameAndTypeEntry(in, jc);
            }
        }
        throw new ErrorException("Illegal constant pool entry");
    }

    public static String getTypeName(int type) {
        switch (type) {
            case 1: {
                return "UTF8";
            }
            case 3: {
                return "Integer";
            }
            case 4: {
                return "Float";
            }
            case 5: {
                return "Long";
            }
            case 6: {
                return "Double";
            }
            case 7: {
                return "Class";
            }
            case 8: {
                return "String";
            }
            case 9: {
                return "FieldRef";
            }
            case 10: {
                return "MethodRef";
            }
            case 11: {
                return "InterfaceMethodRef";
            }
            case 12: {
                return "NameAndType";
            }
        }
        return "Type[" + type + "]";
    }

    protected static byte[] readUTF8ByteArray(DataInputStream in) throws IOException {
        short length = in.readShort();
        byte[] bytes = new byte[length];
        in.read(bytes, 0, length);
        return bytes;
    }

    protected static byte[] toByteArray(String str) {
        int n = str.length();
        byte[] bytes = new byte[n];
        int i = 0;
        while (i < n) {
            char ch = str.charAt(i);
            if (ch == '\u0000' || ch > '\u007f') {
                throw new ErrorException("Illegal UTF8 string");
            }
            bytes[i] = (byte)(ch & 0x7F);
            ++i;
        }
        return bytes;
    }

    protected static String toString(byte[] bytes) {
        int n = bytes.length;
        char[] chars = new char[n];
        int i = 0;
        while (i < n) {
            chars[i] = (char)bytes[i];
            ++i;
        }
        return new String(chars);
    }
}

